<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>BRTA PDF</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link href="https://fonts.maateen.me/solaiman-lipi/font.css" rel="stylesheet">
    <style>
        .pdfTable {
            font-size: 14px;
        }

        body {
            font-family: 'SolaimanLipi', sans-serif;
        }
    </style>
</head>

<body>

    <div class="container py-5">
        <div class="row">
            <div class="col-lg-12">
                <h6 class="text-center text-white py-2" style="background: blueviolet; font-size:16px">দুর্ঘটনার ক্ষতি পূরণ সংক্রান্ত আর্থিক সহায়তা তহবিল হইতে আর্থিক সহায়তা
                    প্রাপ্তির
                    আবেদন </h6>
                <table class="table pdfTable">
                    <tbody>
                        <tr>
                            <td>Application Reference Number</td>
                            <td class="pdfTable">#{{ $invoice?->application_number }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">দুর্ঘটনায় ক্ষতিগ্রস্ত ব্যক্তির নাম</td>
                            <td class="pdfTable">{{ $invoice?->victim_name }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">পিতা/স্বামী/স্ত্রীর নাম</td>
                            <td class="pdfTable">{{ $invoice?->father_husband_name }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">মাতার নাম</td>
                            <td class="pdfTable">{{ $invoice?->mother_name }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">মৃত ব্যক্তির ক্ষেত্রে আবেদনকারীর নাম</td>
                            <td class="pdfTable">{{ $invoice?->applicant_name }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">আবেদনকারীর সাথে মৃত ব্যক্তির সম্পর্ক</td>
                            <td class="pdfTable">{{ $invoice?->relation_with_deceased }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">দুর্ঘটনায় ক্ষতিগ্রস্ত ব্যক্তির জন্ম তারিখ</td>
                            <td class="pdfTable">{{ $invoice?->victim_birthdate }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">জাতীয় পরিচয়পত্রের নম্বর </td>
                            <td class="pdfTable">{{ $invoice?->national_id }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">ড্রাইভিং লাইসেন্স নম্বর (চালকের ক্ষেত্রে) ও মেয়াদ </td>
                            <td class="pdfTable">{{ $invoice?->driving_license }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">ঠিকানা </td>
                            <td class="pdfTable">{{ $invoice?->address }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">আবেদনকারীর মোবাইল নাম্বার </td>
                            <td class="pdfTable">{{ $invoice?->phone }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">দুর্ঘটনার স্থানসহ বিবরণ </td>
                            <td class="pdfTable">{{ $invoice?->accident_description }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">দুর্ঘটনার তারিখ ও সময় </td>
                            <td class="pdfTable">{{ $invoice?->accident_date_time }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">দুর্ঘটনার মামলার ডিডি নম্বর </td>
                            <td class="pdfTable">{{ $invoice?->case_dd_number }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">মৃত ব্যক্তির ক্ষেত্রে মৃত্যুর তারিখ (মৃত্যু সনদ সংযুক্ত) </td>
                            <td class="pdfTable">{{ $invoice?->death_date }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">মোট খরচের পরিমাণ (প্রমাণসহ) </td>
                            <td class="pdfTable">{{ $invoice?->total_expense }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">বর্তমান ঠিকানা </td>
                            <td class="pdfTable">{{ $invoice?->current_address }}</td>
                        </tr>
                        <tr>
                            <td class="pdfTable">আর্থিক সহায়তা তহবিল হইতে গত /চলতি বছরে পাইয়া থাকিলে অনুদান প্রাপ্তির
                                খাতের নাম ও টাকার পরিমান </td>
                            <td class="pdfTable">{{ $invoice?->fund_aid }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
    </script>
</body>

</html>
